#ifndef _TP_CTL_H_
#define _TP_CTL_H_

#define MSG_SIZE_RCV 1500
#define IPV6_ADDR_LEN 16
#define LOCAL_ADDR_MAX 20


#define PATH_PROCNET_IFNET6 "/proc/net/if_inet6"
#define DHCP6S_CONFIG_FILE_PATH "/tmp/dhcp6s.conf"
#define RADVD_CONFIG_FILE_PATH "/tmp/radvd.conf"
#define RADVD_PID_FILE_PATH "/tmp/radvd.pid"



struct ip6Addr
{
        int prelen;
        unsigned char addr[IPV6_ADDR_LEN];
};

struct localAddr
{
        int num;
        struct ip6Addr addr[LOCAL_ADDR_MAX];
};

struct in6_ifreq {
        struct in6_addr ifr6_addr;
        unsigned int    ifr6_prefixlen;
        int             ifr6_ifindex;
};

struct ctl_para {
	char *ifname;
	char *conffile;
};



void printIPv6(const char *str, int line, unsigned char * addr);
void *tp_ctl(void *arg);

#endif
